﻿<?xml version="1.0" ?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:feed="http://www.w3.org/2005/Atom"
				xmlns:frc="http://www.feedreader.com/ns/3.0/frc"
				xmlns:fr="http://www.feedreader.com/ns/3.0"
				version="1.0">
<xsl:output method="html" />

<xsl:template match="/">

<html>
<head>
<style>
img {
float:right;
margin-left:1em;
}
body,table {
margin:0;
padding:0;
font-family:trebuchet ms;
font-size:12px;
overflow:auto;
}
</style>
<base>    
<xsl:attribute name="href"><xsl:value-of select="/feed:feed/feed:entry/feed:source/feed:link[@rel='alternate'][1]/@href"/>/</xsl:attribute>
</base> 
</head>	
<body style="filter:progid:DXImageTransform.Microsoft.Gradient(endColorstr='#999798', startColorstr='#BDBDBC', gradientType='0');">
<xsl:apply-templates select="feed:feed"/>
</body>
</html>
</xsl:template>

<xsl:template match="feed:feed">
  <xsl:value-of disable-output-escaping="yes" select="fr:opmldescr"/>
  <xsl:apply-templates select="feed:entry"/>
</xsl:template>

<xsl:template match="feed:entry">

	<div class="entry">
<span class="updated"><xsl:value-of select="fr:updated"/>, </span>		
			<xsl:if test="feed:author"> 
	  			<span class="author">
				<xsl:apply-templates select="feed:author"/>
				</span>
			</xsl:if>

<xsl:if test="feed:content">
		<div class="content">
			<xsl:value-of disable-output-escaping="yes" select="feed:content"/>
		</div>
	</xsl:if>
	<div class="clear" />
	</div>
</xsl:template>
</xsl:stylesheet>
